<?php 
namespace Void_ewhmcsep\Widgets;

use Elementor\Controls_Manager;



add_action( 'elementor/element/price-table/section_header/before_section_start', function( $element, $args ) {
  /** @var \Elementor\Element_Base $element */
  $element->start_controls_section(
    'void_whmcs_section',
    [
      'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      'label' => __( 'Void WHMCSE Pro', 'void_ewhmcsep' ),
    ]
  );

  $element->add_control(
      'whmcs_url',
      [
        'label' => __( 'WHMCS URL', 'void_ewhmcsep' ),
        'description' => __( 'Used when you do not have WHMCS Bridge Plugin installed to get/send data. Do not add (/). Just input direct url of your whmcs area (not admin url). ex: https://testsite/whmcs', 'void_ewhmcsep' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => 'https://voidcoders.com/voidwhmcs',
      ]
    );

  $element->add_control(
      'packedge_id',
      [
        'label' => esc_html__( 'Packedge ID of WHMCS', 'void_ewhmcsep' ),
        'description' => esc_html__('Provide the Packedge ID number of your product so the system can get the details of product via the ID from your defined WHMCS url in above. The Featched data will be visible to page after you hit save & check the page', 'void_ewhmcsep'),
        'type' => Controls_Manager::NUMBER,
        'default' => '1',
        'label_block' => true,
      ]
    );

  $element->add_control(
      'auto_title',
      [
        'label' => __( 'Get Title from WHMCS', 'void_ewhmcsep' ),
        'type' => Controls_Manager::SWITCHER,
        //'default' => '0',
        'description' => 'If turned on the packedge name is featched automatically from your whmcs url defined above and replaces the Header Title. Give the ID of your product of WHMCS Product in the Product ID field so that the data can be fatched',
        'return_value' => '1',
      ]
    );

  $element->add_control(
      'auto_price',
      [
        'label' => __( 'Get Price from WHMCS', 'void_ewhmcsep' ),
        'type' => Controls_Manager::SWITCHER,
        //'default' => '0',
        'description' => 'If turned on the packedge price is featched automatically from your whmcs url defined above and replaces the Prings Price. Give the ID of your product of WHMCS Product so that the data can be fatched in product id filed',
        'return_value' => '1',
      ]
    );

    $element->add_control(
      'currency_number',
      [
        'label' => __( 'Currency Number', 'void_ewhmcsep' ),
        'description' => __( 'The currency number from your WHMCS. Generally the default currency is numbered: 1', 'void_ewhmcsep' ),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => '1',
        'condition' => [
          'auto_price' => '1',
        ]
      ]
      
    );

    $element->add_control(
        'billingcycle',
        [
           'label'       => __( 'Billing Cycle', 'void_ewhmcsep' ),
           'type' => Controls_Manager::SELECT,
           'description' => 'If the billing cycle does not exist in the whmcs it will not show up correct data!',
           'default' => 'monthly',
           'options' => [
            'monthly'  => esc_html__( 'Monthly', 'void_ewhmcsep' ),
            'quarterly'  => esc_html__( 'Quarterly', 'void_ewhmcsep' ),
            'quarterly'  => esc_html__( 'Quarterly', 'void_ewhmcsep' ),
            'semiannually'  => esc_html__( 'Semiannually', 'void_ewhmcsep' ),
            'annually'  => esc_html__( 'Annually', 'void_ewhmcsep' ),
            'biennially'  => esc_html__( 'Biennially', 'void_ewhmcsep' ),
            'triennially'  => esc_html__( 'Triennially', 'void_ewhmcsep' ),
           ],
          'condition' => [
          'auto_price' => '1',
        ],
        ]
      );




  $element->end_controls_section();
}, 10, 2 );





add_action( 'elementor/widget/before_render_content', function($widget ) {
  if ( 'price-table' === $widget->get_name() ) 
  {
    $settings = $widget->get_settings(); 
 
   //if - check to stop un-necessery functions if options are disabled - return content directly.
    if(empty($settings['auto_title']) && empty($settings['auto_price']) ){
      return;
    }

    if( empty($settings['heading']) && !empty($settings['auto_title']))
      { 
        $widget->set_settings('heading', 'voidtestheading'); 
      }  

      if(!empty($settings['auto_price']))
      { 
        $widget->set_settings('price', '999.90'); 
      }


    add_action( 'elementor/widget/render_content', function( $content, $widget ) {
        if ( 'price-table' !== $widget->get_name() ) {
          return $content;
        }

        $settings = $widget->get_settings(); 
         if(empty($settings['auto_title']) && empty($settings['auto_price']) ){
            return $content;
          }
        if( $settings['auto_title'] && $settings['whmcs_url']!='' && $settings['packedge_id'] && !\Elementor\Plugin::$instance->editor->is_edit_mode() ) 
          { 
            ob_start();
            echo'<script language="javascript" src="'.$settings['whmcs_url'].'/feeds/productsinfo.php?pid='. $settings['packedge_id'] .'&get=name"></script>'; 
            $modified_heading = ob_get_clean();
            $content=str_replace($settings['heading'], $modified_heading, $content ); 
          } 

        if( $settings['auto_price'] && $settings['whmcs_url']!='' && $settings['packedge_id'] && !\Elementor\Plugin::$instance->editor->is_edit_mode() ) 
          { 
            
              $request = wp_remote_get( $settings['whmcs_url'].'/feeds/productsinfo.php?pid='. $settings['packedge_id'] .'&get=price&billingcycle='. $settings['billingcycle'] .'&currency='.$settings['currency_number'] );
              $body = wp_remote_retrieve_body( $request );


              $price_new =ltrim(preg_replace('/[^0-9.]/', '', $body), '.');
              
              //new price explode
              $price_new = explode( '.', $price_new);
              $intpart_new = $price_new[0];
              $fraction_new = '';
              if ( 2 === count( $price_new ) ) {
                $fraction_new = $price_new[1];
              }

              //false old price explode
              $price = explode( '.', $settings['price'] );
              $intpart = $price[0];
              $fraction = '';
              if ( 2 === count( $price ) ) {
                $fraction = $price[1];
              }
              
              $content=str_replace($intpart, $intpart_new, $content ); 
              $content=str_replace($fraction, $fraction_new, $content ); 

          }
            
       return $content;
    }, 10, 2 );


  }

} );

//render function modification
